/*
 * Decompiled with CFR 0.152.
 */
package org.blocovermelho.ae2emicrafting.client.helper;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.AEBaseMenu;
import appeng.menu.slot.FakeSlot;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_768;
import org.blocovermelho.ae2emicrafting.client.helper.interfaces.DropTarget;

public final class DropTargets {
    private DropTargets() {
    }

    public static List<DropTarget> getTargets(AEBaseScreen<?> aeScreen) {
        ArrayList<DropTarget> targets = new ArrayList<DropTarget>();
        for (class_1735 slot : ((AEBaseMenu)aeScreen.method_17577()).field_7761) {
            if (!slot.method_7682() || !(slot instanceof FakeSlot)) continue;
            FakeSlot fakeSlot = (FakeSlot)slot;
            class_768 area = new class_768(aeScreen.getGuiLeft() + slot.field_7873, aeScreen.getGuiTop() + slot.field_7872, 16, 16);
            targets.add(new FakeSlotDropTarget(area, fakeSlot));
        }
        return targets;
    }

    private record FakeSlotDropTarget(class_768 area, FakeSlot slot) implements DropTarget
    {
        @Override
        public boolean canDrop(GenericStack stack) {
            return this.slot.canSetFilterTo(FakeSlotDropTarget.wrapFilterAsItem(stack));
        }

        @Override
        public boolean drop(GenericStack stack) {
            class_1799 itemStack = FakeSlotDropTarget.wrapFilterAsItem(stack);
            if (this.slot.canSetFilterTo(itemStack)) {
                NetworkHandler.instance().sendToServer((BasePacket)new InventoryActionPacket(InventoryAction.SET_FILTER, this.slot.field_7874, itemStack));
                return true;
            }
            return false;
        }

        private static class_1799 wrapFilterAsItem(GenericStack genericStack) {
            AEKey aEKey = genericStack.what();
            if (aEKey instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)aEKey;
                return itemKey.toStack(Ints.saturatedCast((long)Math.max(1L, genericStack.amount())));
            }
            return GenericStack.wrapInItemStack((AEKey)genericStack.what(), (long)Math.max(1L, genericStack.amount()));
        }
    }
}

